/*
 * Decompiled with CFR 0.152.
 */
package ru.pinkgoosik.visuality.mixin;

import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1766;
import net.minecraft.class_1792;
import net.minecraft.class_1829;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_310;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import ru.pinkgoosik.visuality.VisualityMod;
import ru.pinkgoosik.visuality.registry.HitParticleRegistry;
import ru.pinkgoosik.visuality.registry.VisualityParticles;
import ru.pinkgoosik.visuality.util.ParticleUtils;
import ru.pinkgoosik.visuality.util.ShinyArmorUtils;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297 {
    class_1309 self = (class_1309)class_1309.class.cast((Object)this);
    int ticksDelay = 0;

    @Shadow
    public abstract boolean method_5805();

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tick(CallbackInfo ci) {
        if (this.field_6002.field_9236 && this.ticksDelay != 0) {
            --this.ticksDelay;
        }
        if (this.field_6002.field_9236 && this.method_5805() && class_310.method_1551().field_1724 != null && VisualityMod.CONFIG.getBoolean("enabled", "shiny_armor")) {
            int shinyLevel = ShinyArmorUtils.getShinyLevel(this.self);
            if (class_310.method_1551().field_1724.method_5667().equals(this.method_5667())) {
                if (!class_310.method_1551().field_1690.method_31044().method_31034()) {
                    this.spawnSparkles(shinyLevel);
                }
            } else {
                this.spawnSparkles(shinyLevel);
            }
        }
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")})
    void damage(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1297 class_12972;
        if (this.field_6002.field_9236 && (class_12972 = source.method_5529()) instanceof class_1309) {
            class_1309 attacker = (class_1309)class_12972;
            if (this.ticksDelay == 0 && this.method_5805() && VisualityMod.CONFIG.getBoolean("enabled", "hit_particles")) {
                HitParticleRegistry.ENTRIES.forEach(entry -> {
                    if (this.method_5864().equals(entry.entity())) {
                        this.ticksDelay = 10;
                        class_1792 item = attacker.method_6047().method_7909();
                        int count = this.field_5974.nextInt(2);
                        if (item instanceof class_1829) {
                            class_1829 swordItem = (class_1829)item;
                            count = (int)swordItem.method_8020() / 2;
                        } else if (item instanceof class_1766) {
                            class_1766 miningToolItem = (class_1766)item;
                            count = (int)miningToolItem.method_26366() / 2;
                        }
                        this.spawnHitParticles(entry.particle(), count);
                    }
                });
            }
        }
    }

    @Unique
    private void spawnHitParticles(class_2394 particle, int count) {
        float height = this.method_17682();
        height = height * 100.0f < 100.0f ? 1.0f : (height += 0.5f);
        for (int i = 0; i <= count; ++i) {
            double randomHeight = (double)this.field_5974.nextInt((int)height * 10) / 10.0;
            ParticleUtils.add(this.field_6002, particle, this.method_23317(), this.method_23318() + 0.2 + randomHeight, this.method_23321());
        }
    }

    @Unique
    private void spawnSparkles(int shinyLevel) {
        if (shinyLevel > 0 && this.field_5974.nextInt(20 - shinyLevel) == 0) {
            double x = this.field_5974.nextFloat() * 2.0f - 1.0f;
            double y = this.field_5974.nextFloat();
            double z = this.field_5974.nextFloat() * 2.0f - 1.0f;
            ParticleUtils.add(this.field_6002, (class_2394)VisualityParticles.SPARKLE, this.method_23317() + x, this.method_23318() + y + 1.0, this.method_23321() + z);
        }
    }
}

